function [deltaobj]=desviacion(fun,x,y0,yobj)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                        %
% Funcion auxiliar al metodo de disparo                                  %
%                                                                        %
% Integra un problema de ODE-CI mediante la rutina ODE45 y devuelve      %
% la diferencia entre el ultimo valor de la variable dependiente y       %
% el valor objetivo.                                                     %
%                                                                        %
% [deltaobj]=desviacion(fun,x,y0,yobj)                                   %
%                                                                        %
% ENTRADA                                                                %
%                                                                        %
%  FUN : ecuacion o sistema de ODEs a integrar (igual a ODE45).          %
%  X   : intervalo de integracion (igual a ODE 45).                      %
%  Y0  : condiciones iniciales (igual a ODE45).                          %
%  YOBJ : valor objetivo                                                 %
%  TOL  : tolerancia relativa de la integracion                          %
%                                                                        %
%                                                                        %
%  SALIDA                                                                %
%                                                                        %
%   DELTAOBJ : Y(end)-YOBJ                                               %
%                                                                        %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[xs, ys] = ode45( fun, x, y0);
deltaobj = ys(end,1)-yobj;